<?php echo $__env->make('layouts.landing-page.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<section class="page-info-section">
  <div class="container">
    <h2>Indonesia Peduli</h2>
    <div class="site-beradcamb">
      <a href="/">Indonesia Peduli</a>
      <span><i class="fa fa-angle-right"></i> <?php echo e($title); ?></span>
    </div>
  </div>
</section>
<!-- Page info end -->

<!-- Review section -->
<section class="review-section spad">
  <div class="container">
    <div class="review-text-slider owl-carousel">
      <?php $__currentLoopData = $data_program_donasi_utama; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $program_donasi_utama): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <div class="review-text">
        <div class="row">
          <div class="col-lg-5">
            <img src="/gambar-program-donasi/<?php echo e($program_donasi_utama->gambar); ?>" alt="" class="mx-auto">
          </div>
          <div class="col-lg-7">
            <h3><?php echo e($program_donasi_utama->judul); ?></h3>
            <p><b><?php echo e($program_donasi_utama->deskripsi); ?></b></p>

            <p><?php echo Str::limit($program_donasi_utama->kisah, 300, $end='...'); ?> <a href="<?php echo e(route('home.show', $program_donasi_utama->id)); ?>" target="_black"> Baca Selengkapnya</a></p>
            <a href="<?php echo e(route('home.show', $program_donasi_utama->id)); ?>" target="_black" class="site-btn sb-gradients sbg-line mt-2 mb-2">Donasi Sekarang</a>
          </div>
        </div>
      </div>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
  </div>
</section>
<!-- Review section end -->


<!-- Blog section -->
<section class="team-section spad pb-4 pt-4">
  <div class="container">
    <div class="section-title text-center">
      <h2>Program Donasi Mendesak</h2>
    </div>
    <div class="row">
      <div class="col-lg-12">
        <div class="row">
          <!-- blog item -->
          <?php $__currentLoopData = $data_program_donasi_mendesak; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $program_donasi_mendesak): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <a href="<?php echo e(route('home.show', $program_donasi_mendesak->id)); ?>">
            <div class="col-lg-4 col-md-6">
              <div class="blog-item">
                <figure class="blog-thumb">
                  <img src="/gambar-program-donasi/<?php echo e($program_donasi_mendesak->gambar); ?>" alt="" height="200px" class="mx-auto d-block">
                </figure>
                <div class="blog-text">
                  <div class="post-date">Berakhir <?php echo e($program_donasi_mendesak->batas_akhir_donasi->diffForHumans()); ?></div>
                  <h4 class="blog-title"><?php echo e(Str::limit($program_donasi_mendesak->deskripsi, 25, $end='...')); ?></h4>

                  <div class=" progress" style="height: 5px;">
                    <div class="progress-bar" role="progressbar" style="width: <?php echo e($program_donasi_mendesak->prosentasi_terdanai); ?>%" aria-valuenow="<?php echo e($program_donasi_mendesak->prosentasi_terdanai); ?>" aria-valuemin="0" aria-valuemax="100"></div>
                  </div>

                  <div class="post-meta">
                    <a class="float-left"><span>Terdanai</span></a>
                    <a class="float-right"><span>Kekurangan</span></a>
                  </div>
                  <div class="post-meta">
                    <a><?php echo e(rupiah($program_donasi_mendesak->terdanai)); ?></a>
                    <a class="float-right"><?php echo e(rupiah($program_donasi_mendesak->kebutuhan_dana - $program_donasi_mendesak->terdanai)); ?></a>
                  </div>

                  <div class="post-meta mt-2">
                    <a><i class="fa fa-users"></i> <?php echo e($program_donasi_mendesak->jumlah_donatur); ?> donatur</a>
                    <?php if(is_null($program_donasi_mendesak->is_liked)): ?>
                    <a><i class="fa fa-heart-o"></i> <?php echo e($program_donasi_mendesak->jumlah_like); ?> likes</a>
                    <?php else: ?>
                    <a><i class="fa fa-heart"></i> <?php echo e($program_donasi_mendesak->jumlah_like); ?> likes</a>
                    <?php endif; ?>
                    <a><i class="fa fa-comments-o"></i> <?php echo e($program_donasi_mendesak->jumlah_komentar); ?> comments</a>
                  </div>
                </div>
              </div>
            </div>
          </a>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
      </div>
    </div>
  </div>
</section>

<section class="blog-page spad pt-4">
  <div class="container">
    <div class="section-title text-center">
      <h2>Program Donasi Lain</h2>
    </div>
    <div class="row">
      <div class="col-lg-12">
        <div class="row">
          <!-- blog item -->
          <?php $__currentLoopData = $data_program_donasi_lain; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $program_donasi_lain): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <a href="<?php echo e(route('home.show', $program_donasi_lain->id)); ?>">
            <div class="col-lg-4 col-md-6">
              <div class="blog-item">
                <figure class="blog-thumb">
                  <img src="/gambar-program-donasi/<?php echo e($program_donasi_lain->gambar); ?>" alt="" height="200px" class="mx-auto d-block">
                </figure>
                <div class="blog-text">
                  <div class="post-date">Berakhir <?php echo e($program_donasi_lain->batas_akhir_donasi->diffForHumans()); ?></div>
                  <h4 class="blog-title"><?php echo e(Str::limit($program_donasi_lain->deskripsi, 25, $end='...')); ?></h4>

                  <div class=" progress" style="height: 5px;">
                    <div class="progress-bar" role="progressbar" style="width: <?php echo e($program_donasi_lain->prosentasi_terdanai); ?>%" aria-valuenow="<?php echo e($program_donasi_lain->prosentasi_terdanai); ?>" aria-valuemin="0" aria-valuemax="100"></div>
                  </div>

                  <div class="post-meta">
                    <a class="float-left"><span>Terdanai</span></a>
                    <a class="float-right"><span>Kekurangan</span></a>
                  </div>
                  <div class="post-meta">
                    <a><?php echo e(rupiah($program_donasi_lain->terdanai)); ?></a>
                    <a class="float-right"><?php echo e(rupiah($program_donasi_lain->kebutuhan_dana - $program_donasi_lain->terdanai)); ?></a>
                  </div>

                  <div class="post-meta mt-2">
                    <a><i class="fa fa-users"></i> <?php echo e($program_donasi_lain->jumlah_donatur); ?> donatur</a>
                    <?php if(is_null($program_donasi_lain->is_liked)): ?>
                    <a><i class="fa fa-heart-o"></i> <?php echo e($program_donasi_lain->jumlah_like); ?> likes</a>
                    <?php else: ?>
                    <a><i class="fa fa-heart"></i> <?php echo e($program_donasi_lain->jumlah_like); ?> likes</a>
                    <?php endif; ?>
                    <a><i class="fa fa-comments-o"></i> <?php echo e($program_donasi_lain->jumlah_komentar); ?> comments</a>
                  </div>
                </div>
              </div>
            </div>
          </a>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <a href="<?php echo e(route('home.all')); ?>" class="post-loadmore site-btn sb-gradients sbg-line mt-5">LIHAT SEMUA PROGRAM</a>
      </div>
    </div>
  </div>
</section>
<!-- Blog section end -->

<?php echo $__env->make('layouts.landing-page.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp74\htdocs\peduli\resources\views/landing-page/home.blade.php ENDPATH**/ ?>